/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CBitmap.h,v 1.2 1999/09/17 04:20:46 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CBitmap_h	// [
#define Included_CBitmap_h

#include "pgpClassesConfig.h"
#include "CPoint.h"

_PGP_BEGIN

// Types

class CPalette;
class CRect;


// Class CBitmap

class CBitmap
{
	NOT_COPYABLE(CBitmap)

public:
	CBitmap();
	CBitmap(HBITMAP bitmap);
	CBitmap(HINSTANCE instance, const char *name, PGPBoolean shared = FALSE);
	CBitmap(HINSTANCE instance, const char *name, CPalette& palette);
	~CBitmap();

	CBitmap&	operator=(HBITMAP bitmap);

	operator HBITMAP() const {return mBitmap;}
	HBITMAP	Get() const {return mBitmap;}

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	void	PaintWithPalette(HDC dc, HPALETTE palette, CPoint origin) const;

	void	CreateCompatible(HDC hDC, PGPInt32 width, PGPInt32 height);
	void	CreateWithPalette(HINSTANCE instance, const char *name, 
		CPalette& palette);
	void	Load(HINSTANCE instance, const char *name, 
		PGPBoolean shared = FALSE);
	void	Attach(HBITMAP bitmap);
	void	Clear();

	HBITMAP	Release();	// Clear without freeing resources

private:
	PGPBoolean	mWeCreated;
	HBITMAP		mBitmap;

	PGPUInt32	mWidth;
	PGPUInt32	mHeight;
};


// Class CBitmap member functions

inline 
CBitmap::CBitmap() : mWeCreated(FALSE), mBitmap(NULL)
{
}

inline 
CBitmap::CBitmap(HBITMAP bitmap) : mWeCreated(FALSE), mBitmap(NULL)
{
	Attach(bitmap);
}

inline 
CBitmap::CBitmap(HINSTANCE instance, const char *name, PGPBoolean shared) : 
	mWeCreated(FALSE), mBitmap(NULL)
{
	Load(instance, name, shared);
}

inline 
CBitmap::CBitmap(HINSTANCE instance, const char *name, CPalette& palette) : 
	mWeCreated(FALSE), mBitmap(NULL)
{
	CreateWithPalette(instance, name, palette);
}

inline 
CBitmap::~CBitmap()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
PGPBoolean 
CBitmap::IsAttached() const
{
	return IsntNull(mBitmap);
}

_PGP_END

#endif	// ] Included_CBitmap_h
